<?php

if(empty($_REQUEST['id'])) {
    echo "Please visit the <a href='search.php'>search</a> page.";
    exit();
}

$host   = "webdev.iyaserver.com"; 
$db     = "dent_exam";
$userid = "dent_test";
$userpw = "Acad276_Ttrojan_Dev2Ex@m";

$mysql = new mysqli(
    $host,
    $userid,
    $userpw,
    $db
);

if($mysql->connect_errno) {
    echo "db connection error : " . $mysql->connect_error;
    exit();
}

$id = (int)$_REQUEST['id'];

$sql  = "SELECT ";
$sql .= " d.device_id, d.name, d.price, d.img_url, ";
$sql .= " m.manufacturer AS manufacturer, ";
$sql .= " s.system       AS system, ";
$sql .= " t.type         AS type ";
$sql .= "FROM device d ";
$sql .= "JOIN make       m ON d.manufacturer_id = m.manufacturer_id ";
$sql .= "JOIN os         s ON d.system_id       = s.system_id ";
$sql .= "JOIN devicetype t ON d.type_id         = t.type_id ";
$sql .= "WHERE d.device_id = " . $id;

$results = $mysql->query($sql);

if(!$results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}

if($results->num_rows == 0) {
    echo "No such device.";
    exit();
}

?>

<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <title>Acad276 Practical Exam: Details</title>
    <style>
        .container {
            width:  800px;
            margin: auto;
        }
        h1 {
            margin: auto;
            text-align: center;
            background-color:   #900;
            color:  #FC0;
            height: 60px;
            line-height: 60px;
        }
        .details {
            border:     1px solid #990000;
            width:      600px;
            margin:     auto;
            margin-top: 20px;
            padding:    20px;
        }
        table {
            height: 300px;
            width:      100%;
        }
        table img {
            height: 300px;

        }
        img {
            width: 300px;

        }
        .label {
            text-align: right;
            width:      20%;
            padding:    3px 10px 3px;
        }
        .data {
            width: 40%;
        }
        .input>input, .input>select {
            width:  100%;
        }
        .nav-link{
            margin: 10px 0px;
            font-size: 14px;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Mobile Device Database: Details Page</h1>
    <div class="nav-link">
        <a href="search.php"><< Back to Search Page</a>
    </div>
    

    <div class="details">
  <table>
    <?php while ($currentrow = $results->fetch_assoc()) { ?>
      <tr>
        <td rowspan="5" class="img">
          <img src="https://image.shutterstock.com/image-vector/vector-sketch-illustration-human-hand-260nw-605728496.jpg" alt="device image">
        </td>
        <td class="label">Name:</td>
        <td class="data"><strong><em><?php echo $currentrow['name']; ?></em></strong></td>
      </tr>
      <tr>
        <td class="label">Price:</td>
        <td><strong><?php echo number_format((float)$currentrow['price'], 2); ?></strong></td>
      </tr>
      <tr>
        <td class="label">Manufacturer:</td>
        <td><?php echo $currentrow['manufacturer']; ?></td>
      </tr>
      <tr>
        <td class="label">System:</td>
        <td><?php echo $currentrow['system']; ?></td>
      </tr>
      <tr>
        <td class="label">Type:</td>
        <td><?php echo $currentrow['type']; ?></td>
      </tr>
    <?php } // end loop ?>
  </table>
</div>


</body>
</html>